/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureSprite;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureType;
import com.supermartijn642.fusion.texture.types.random.RandomTextureSprite;
import com.supermartijn642.fusion.texture.types.random.RandomTextureType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class BaseBakedModel
implements class_1087 {
    private final Mesh mesh;
    private final List<class_1058> sprites;
    private final boolean hasSpecialQuads;
    private final class_1058 particleIcon;

    public BaseBakedModel(List<BaseModelQuad> quads, Boolean hasAmbientOcclusion, class_1058 particleIcon) {
        this.particleIcon = particleIcon;
        MutableMesh builder = Renderer.get().mutableMesh();
        QuadEmitter emitter = builder.emitter();
        HashMap<class_1058, Integer> sprites = new HashMap<class_1058, Integer>();
        boolean hasSpecialQuads = false;
        for (BaseModelQuad quad : quads) {
            emitter.fromBakedQuad(quad.bakedQuad());
            emitter.cullFace(quad.cullDirection());
            FusionClient.applyMaterialProperties(emitter, hasAmbientOcclusion, quad.renderType(), quad.emissive());
            if (quad.textureType() == DefaultTextureTypes.RANDOM || quad.textureType() == DefaultTextureTypes.CONTINUOUS) {
                int type = quad.textureType() == DefaultTextureTypes.RANDOM ? 2 : 3;
                int spriteIndex = sprites.computeIfAbsent(quad.bakedQuad().comp_3724(), o -> sprites.size());
                emitter.tag(type | spriteIndex << 4);
                hasSpecialQuads = true;
            }
            emitter.emit();
        }
        this.mesh = builder.immutableCopy();
        this.sprites = sprites.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).toList();
        this.hasSpecialQuads = hasSpecialQuads;
    }

    public List<class_10889> method_68512(class_5819 randomSource) {
        return List.of();
    }

    public void method_68513(class_5819 randomSource, List<class_10889> list) {
    }

    public void emitQuads(QuadEmitter emitter, class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random, Predicate<@Nullable class_2350> cullTest) {
        if (!this.hasSpecialQuads) {
            this.mesh.outputTo(emitter);
            return;
        }
        boolean[] culledFaces = new boolean[]{cullTest.test(class_2350.field_11033), cullTest.test(class_2350.field_11036), cullTest.test(class_2350.field_11043), cullTest.test(class_2350.field_11035), cullTest.test(class_2350.field_11039), cullTest.test(class_2350.field_11034)};
        MutableQuad mutableQuad = new MutableQuad();
        emitter.pushTransform(quad -> {
            if (quad.tag() != 0) {
                class_2350 cullFace = quad.cullFace();
                if (cullFace != null && culledFaces[cullFace.ordinal()]) {
                    return false;
                }
                int tag = quad.tag();
                int type = quad.tag() & 0xF;
                int spriteIndex = tag >> 4 & 0xFF;
                class_1058 sprite = this.sprites.get(spriteIndex);
                quad.tag((int)Math.floor((sprite.field_5269 + sprite.field_5270) / 2.0f * 65535.0f) | (int)Math.floor((sprite.field_5267 + sprite.field_5268) / 2.0f * 65535.0f) << 16);
                if (type == 2) {
                    mutableQuad.set(quad);
                    RandomTextureType.processQuad(mutableQuad, pos, quad.nominalFace(), random, (RandomTextureSprite)sprite);
                    return true;
                }
                if (type == 3) {
                    mutableQuad.set(quad);
                    ContinuousTextureType.processQuad(mutableQuad, pos, quad.nominalFace(), (ContinuousTextureSprite)sprite);
                    return true;
                }
            }
            return true;
        });
        this.mesh.outputTo(emitter);
        emitter.popTransform();
    }

    @Nullable
    public Object createGeometryKey(class_1920 level, class_2338 pos, class_2680 state, class_5819 random) {
        return this.hasSpecialQuads ? Pair.of(this, pos) : this;
    }

    public class_1058 method_68511() {
        return this.particleIcon;
    }
}

